<!-- CONTENT SECTION -->
<section>
  <div class="container my-3">
    <div class="row justify-content-center align-self-center">
      @foreach ($shops as $shop)
        <div class="col-lg-3 col-sm-4 col-xs-6 p-1">
          <div class="card-box text-center">
            <a href="{{ route('show.store', $shop->slug) }}" class="text-reset">
              @if (config('system_settings.show_merchant_info_as_vendor'))
                <div class="thumb-lg d-flex thumbnail rounded-circle justify-content-center align-items-center mx-auto p-2">
                  <img class="lazy" src="/images/loading.webp" data-src="{{ get_avatar_src($shop->owner, 'logo_square') }}" alt="{{ $shop->name }}">
                </div>

                <h4 class="mb-2 text-muted">{!! $shop->owner->getName() !!}</h4>
              @else
                <div class="thumb-lg d-flex thumbnail rounded-circle justify-content-center align-items-center mx-auto p-2">
                  <img class="lazy" src="/images/loading.webp" data-src="{{ get_storage_file_url(optional($shop->logoImage)->path, 'logo_square') }}" alt="{{ $shop->name }}">
                </div>

                <h4 class="mb-2 text-muted">{!! $shop->getQualifiedName() !!}</h4>
              @endif
            </a>

            @include('theme::layouts.ratings', ['ratings' => $shop->ratings, 'count' => $shop->ratings_count])

            <div class="my-2">
              {{ trans('theme.member_since') . ': ' . $shop->created_at->diffForHumans() }}
            </div>

            {{-- <ul class="social-links list-inline my-3">
              <li class="list-inline-item"><a title="" data-placement="top" data-toggle="tooltip" class="tooltips" href="" data-original-title="Facebook"><i class="fa fa-facebook"></i></a></li>
              <li class="list-inline-item"><a title="" data-placement="top" data-toggle="tooltip" class="tooltips" href="" data-original-title="Twitter"><i class="fa fa-twitter"></i></a></li>
              <li class="list-inline-item"><a title="" data-placement="top" data-toggle="tooltip" class="tooltips" href="" data-original-title="Skype"><i class="fa fa-skype"></i></a></li>
            </ul> --}}

            <a href="{{ route('show.store', $shop->slug) }}" class="btn btn-default btn-rounded waves-effect w-md waves-light">
              {{ trans('theme.visit_shop_page') }}
            </a>

            <div class="row mt-3">
              <div class="col-6">
                <div class="mt-3">
                  <h4>{{ $shop->inventories_count }}</h4>
                  <p class="mb-0 text-muted">{{ trans('theme.active_listings') }}</p>
                </div>
              </div>
              <div class="col-6">
                <div class="mt-3">
                  <h4>{{ $shop->total_item_sold }}</h4>
                  <p class="mb-0 text-muted">{{ trans('theme.items_sold') }}</p>
                </div>
              </div>
            </div>
          </div> <!-- /.card-box -->
        </div> <!-- /.end col -->
      @endforeach
    </div><!-- /.row -->

    <div class="row d-flex justify-content-center pagenav-wrapper mt-5 mb-3">
      {{ $shops->links('theme::layouts.pagination') }}
    </div><!-- /.row .pagenav-wrapper -->
  </div><!-- /.container -->
</section>
<!-- END CONTENT SECTION -->
