<style>
  #all-categories-wrapper .less {
    max-height: 100px !important;
    overflow: hidden;
  }

  .shadow {
    -webkit-box-shadow: 0 0 1px rgba(0, 0, 0, .35);
    -moz-box-shadow: 0 0 1px rgba(0, 0, 0, .35);
    box-shadow: 0 0 1px rgba(0, 0, 0, .35);
  }
</style>
<section>
  <div id="all-categories-wrapper" class="container mt-4 mb-5">
    <div class="row">
      @foreach ($all_categories as $categoryGroup)
        @if ($categoryGroup->subGroups->count())
          <div class="col-12 mb-3 py-4 shadow">
            <h2 class="lead">{{ $categoryGroup->name }}</h2>
            <div class="row px-3">
              @foreach ($categoryGroup->subGroups as $subGroup)
                <div class="col-3 px-1">
                  <h3 class="nav-category-inner-title">
                    <a href="{{ route('categories.browse', $subGroup->slug) }}">{{ $subGroup->name }}</a>
                  </h3>

                  <ul class="nav-category-inner-list show-hide-content less">
                    @foreach ($subGroup->categories as $cat)
                      <li>
                        <a href="{{ route('category.browse', $cat->slug) }}">{{ $cat->name }}</a>
                        {{-- @if ($cat->description)
                          <p>{!! $cat->description !!}</p>
                        @endif --}}
                      </li>
                    @endforeach
                  </ul>
                  <a href="javascript::void(0)" class="small show-hide-content-btn">
                    {{ trans('theme.show_more') }} <i class="fa fa-angle-down"></i>
                  </a>
                </div><!-- /.col-3 -->
              @endforeach
            </div> <!-- /.row -->
          </div><!-- /.col-12 -->

          @if ($loop->iteration % 4 == 0)
            <div class="clearfix"></div>
          @endif

          @if ($loop->iteration % 2 == 0)
            <!-- Add clearfix for only the sm viewport -->
            <div class="clearfix visible-sm-block"></div>
          @endif
        @endif
      @endforeach
    </div> <!-- /.row -->
  </div> <!-- /.container -->
</section>
